<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Drivers_Model extends CI_Model {
  
  private $tableName = 'drivers';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  function get_all_drivers() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("driver_name", "desc");
		$this->db->where("driver_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result();
  }

	function save_driver($driver_data,$driver_id=false)
	{
		if (!$driver_id)
		{
			$this->db->insert($this->tableName,$driver_data);
		}else {
			$this->db->where('driver_id', $driver_id);
			return $this->db->update($this->tableName,$driver_data);
		}
	}	

	function get_all_driver_list() {
		$this->db->select($this->tableName.'.*');
		
		$this->db->order_by("driver_id", "desc");
		$this->db->where("driver_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result(); 
	}
	
		
	function get_all_driver() {
		$this->db->select('drivers.*,warehouses.name');
		$this->db->from('warehouses');
		$this->db->join('drivers', 'drivers.warehouse_id = warehouses.id', 'left');
		$this->db->order_by('driver_id', 'desc');
		$this->db->where("driver_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		
		
		//print_r($query);
		return $query->result_array();
	}
	
	public function get_all_driver_by_warehouse_id($warehouse_id)
	{
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("warehouse_id", $warehouse_id);
		$query = $this->db->get();
		$data=array();
 
//$data[0] = 'SELECT'; 
		foreach ($query->result() as $row)
		{
			$data[$row->driver_id] = $row->driver_name;
		}
	return ($data);
}
		function get_all_drivers_for_invoice_by_wh_id($wh_id)
    {
        $this->db->select('*');
        $this->db->order_by("driver_name", "desc");
		$this->db->where("driver_wh_id", $wh_id);
		$this->db->where("driver_id IS NOT NULL");
        $this->db->where("driver_status", 1);
		$query = $this->db->get('drivers');
        return $query->result_array();
    }
	function get_all_drivers_for_invoice()
    {
        $this->db->select('*');
        $this->db->order_by("driver_name", "desc");
		$this->db->where("driver_id IS NOT NULL");
        $this->db->where("driver_status", 1);
		$query = $this->db->get('drivers');
        return $query->result_array();
    }
	
	
	
	public function get_driver_info($id)
	 {
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("driver_id", $id);
		$this->db->order_by("driver_id", "desc");
		$query = $this->db->get();
		
		return $query->row_array(); 
	 }
	
	public function delete_driver($driver_id)
	{
		$this->db->where('driver_id', $driver_id);
		$this->db->delete($this->tableName);
	
	}

	public function disable_driver($driver_id)
	{
		$data = array(
			'driver_status' => 0
		);	
		$this->db->where('driver_id', $driver_id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable_driver($driver_id)
	{
		$data = array(
			'driver_status' => 1
		);	
		$this->db->where('driver_id', $driver_id);
		$this->db->update($this->tableName, $data);
	}
}