<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Core_Production_Preparation_Model extends CI_Model
{
    private $master_table='production_store_note_master';
    private $master_primary_id='psnm_id';
    private $master_secondry_id='null';
    private $item_table='production_store_note_item';
    private $item_primary_id='psni_id';
    private $item_secondry_id='psnm_id';
    private $sub_item_table='production_batch_items';
    private $sub_item_primary_id='pbi_id';
    private $sub_item_secondry_id='pbm_id';
    
    public function __construct()
    {
        parent::__construct();
       // $this->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
    }
    /* standard functions*/
    protected function saveMaster($pd){
        if ($this->db->insert($this->master_table, $pd)) {
            $lst = $this->db->insert_id();
            return $lst;
        } else {
            return false;
        }
    }
    protected function saveItems($pd){
        if ($this->db->insert($this->item_table, $pd)) {
            $lst = $this->db->insert_id();
            return $lst;
        } else {
            return false;
        }
    }
    protected function saveSubItems($pd){
        if ($this->db->insert($this->sub_item_table, $pd)) {
            $lst = $this->db->insert_id();
            return $lst;
        } else {
            return false;
        }
    }
    protected function updateMasterUsingPrimaryId($id,$data){
        if($id>0){
            $this->db->where($this->master_primary_id, $id);
            return $this->db->update($this->master_table,$data);  
        }else{
            return false;
        }
    }
    protected function updateItemsUsingPrimaryId($id,$data){
        if($id>0){
            $this->db->where($this->item_primary_id, $id);
            return $this->db->update($this->item_table,$data);  
        }else{
            return false;
        }
    }
    protected function updateSubItemsUsingPrimaryId($id,$data){
        if($id>0){
            $this->db->where($this->sub_item_primary_id, $id);
            return $this->db->update($this->sub_item_table,$data);  
        }else{
            return false;
        }
    }
    protected function deleteMasterUsingPrimaryId($id){
        if($id>0){
            $this->db->where($this->master_primary_id, $id);
            return $this->db->delete($this->master_table);  
        }else{
            return false;
        }
    }
    protected function deleteItemsUsingPrimaryId($id){
        if($id>0){
            $this->db->where($this->item_primary_id, $id);
            return $this->db->delete($this->item_table);  
        }else{
            return false;
        }
    }
    protected function deleteSubItemsUsingPrimaryId($id){
        if($id>0){
            $this->db->where($this->sub_item_primary_id, $id);
            return $this->db->delete($this->sub_item_table);  
        }else{
            return false;
        }
    }
    protected function selectMasterUsingPrimaryId($id){
        $this->db->select('*');
        $this->db->from($this->master_table);
        $this->db->where($this->master_primary_id,$id);
         $query = $this->db->get();
          if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
    }
    protected function selectItemsUsingPrimaryId($id){
        $this->db->select('*');
        $this->db->from($this->item_table);
        $this->db->where($this->item_primary_id,$id);
         $query = $this->db->get();
          if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
    }
    protected function selectSubItemsUsingPrimaryId($id){
        $this->db->select('*');
        $this->db->from($this->sub_item_table);
        $this->db->where($this->sub_item_primary_id,$id);
         $query = $this->db->get();
          if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
    }
    protected function updateMasterUsingSecondaryId($id,$data){
        if($id>0){
            $this->db->where($this->master_secondry_id, $id);
            return $this->db->update($this->master_table,$data);  
        }else{
            return false;
        }
    }
    protected function updateItemsUsingSecondaryId($id,$data){
        if($id>0){
            $this->db->where($this->item_secondry_id, $id);
            return $this->db->update($this->item_table,$data);  
        }else{
            return false;
        }
    }
    protected function updateSubItemsUsingSecondaryId($id,$data){
        if($id>0){
            $this->db->where($this->sub_item_secondry_id, $id);
            return $this->db->update($this->sub_item_table,$data);  
        }else{
            return false;
        }
    }
     protected function selectMasterUsingSecondaryId($id){
        $this->db->select('*');
        $this->db->from($this->master_table);
        $this->db->where($this->master_secondry_id,$id);
         $query = $this->db->get();
          if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
    }
    protected function selectItemsUsingSecondaryId($id){
        $this->db->select('*');
        $this->db->from($this->item_table);
        $this->db->where($this->item_secondry_id,$id);
         $query = $this->db->get();
          if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }
    }
    protected function selectSubItemsUsingSecondaryId($id){
        $this->db->select('*');
        $this->db->from($this->sub_item_table);
        $this->db->where($this->sub_item_secondry_id,$id);
         $query = $this->db->get();
          if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }
    }
    
    
    
    
    
    
    
  
}